<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * DistributionSales
 *
 * @ORM\Table(name="distribution_sales")
 * @ORM\Entity()
 *
 * @ExclusionPolicy("all")
 * @ORM\HasLifecycleCallbacks
 */
class DistributionSales
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails","distributionSalesList"})
     */
    private $id;

    /**
     * @var string $name
     *
     * @ORM\Column(name="name", type="string", length=255, nullable=true)
     *
     * @Expose
     * @AnnotationGroups({"companyDetails","distributionSalesList"})
     */
    private $name;

    /**
     * @var integer
     *
     * @ORM\Column(name="discount", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails","distributionSalesList"})
     */
    private $discount;

    /**
     * @var text $efficiency
     *
     * @ORM\Column(name="efficiency", type="text")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails","distributionSalesList"})
     */
    private $efficiency = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="market_segment_id", type="integer")
     */
    private $marketSegmentId;

    /**
     * @ORM\ManyToOne(targetEntity="MarketSegment", inversedBy="distributionSales")
     * @ORM\JoinColumn(name="market_segment_id", referencedColumnName="id")
     */
    protected $marketSegment;

    /**
     * @ORM\OneToMany(targetEntity="CompanyDistributionSales", mappedBy="distributionSales")
     */
    protected $companyDistributionSales;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return DistributionSales
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set discount
     *
     * @param integer $discount
     * @return DistributionSales
     */
    public function setDiscount($discount)
    {
        $this->discount = $discount;
    
        return $this;
    }

    /**
     * Get discount
     *
     * @return integer 
     */
    public function getDiscount()
    {
        return $this->discount;
    }

    /**
     * Set efficiency
     *
     * @param string $efficiency
     * @return DistributionSales
     */
    public function setEfficiency($efficiency)
    {
        $this->efficiency = $efficiency;
    
        return $this;
    }

    /**
     * Get efficiency
     *
     * @return string 
     */
    public function getEfficiency()
    {
        return $this->efficiency;
    }

    /**
     * Set marketSegmentId
     *
     * @param integer $marketSegmentId
     * @return DistributionSales
     */
    public function setMarketSegmentId($marketSegmentId)
    {
        $this->marketSegmentId = $marketSegmentId;
    
        return $this;
    }

    /**
     * Get marketSegmentId
     *
     * @return integer 
     */
    public function getMarketSegmentId()
    {
        return $this->marketSegmentId;
    }

    /**
     * Set marketSegment
     *
     * @param \VM\ApiBundle\Entity\MarketSegment $marketSegment
     * @return DistributionSales
     */
    public function setMarketSegment(\VM\ApiBundle\Entity\MarketSegment $marketSegment = null)
    {
        $this->marketSegment = $marketSegment;
    
        return $this;
    }

    /**
     * Get marketSegment
     *
     * @return \VM\ApiBundle\Entity\MarketSegment 
     */
    public function getMarketSegment()
    {
        return $this->marketSegment;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->companyDistributionSales = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Add companyDistributionSales
     *
     * @param \VM\ApiBundle\Entity\CompanyDistributionSales $companyDistributionSales
     * @return DistributionSales
     */
    public function addCompanyDistributionSale(\VM\ApiBundle\Entity\CompanyDistributionSales $companyDistributionSales)
    {
        $this->companyDistributionSales[] = $companyDistributionSales;
    
        return $this;
    }

    /**
     * Remove companyDistributionSales
     *
     * @param \VM\ApiBundle\Entity\CompanyDistributionSales $companyDistributionSales
     */
    public function removeCompanyDistributionSale(\VM\ApiBundle\Entity\CompanyDistributionSales $companyDistributionSales)
    {
        $this->companyDistributionSales->removeElement($companyDistributionSales);
    }

    /**
     * Get companyDistributionSales
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCompanyDistributionSales()
    {
        return $this->companyDistributionSales;
    }
}